<?php
/**
 * NOTICE OF LICENSE
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2017 D3 Data Development
 * @license   LICENSE.txt
 */

/**
 * Class HeidelpayBasketModel
 */
class HeidelpayBasketModel
{

    /**
     * @var stdClass
     */
    protected $data;

    /**
     * @var HeidelpayBasketValueModel
     */
    protected $basketValueModel;

    /**
     * d3_d3heidelpay_models_generators_basket constructor.
     *
     * @param HeidelpayBasketValueModel $basketValueModel
     * @param HeidelpayConfigModel      $config
     */
    public function __construct(HeidelpayBasketValueModel $basketValueModel, HeidelpayConfigModel $config)
    {
        $this->basketValueModel = $basketValueModel;
        $data                   = new stdClass();
        $data->authentication   = $this->getAuthentication($config);

        $basket                      = new stdClass();
        $basket->amountTotalNet      = $this->convertPrice($basketValueModel->amountTotalNetto);
        $basket->amountTotalVat      = $this->convertPrice($basketValueModel->amountTotalVat);
        $basket->amountTotalDiscount = $this->convertPrice($basketValueModel->amountTotalDiscount);
        $basket->currencyCode        = $basketValueModel->currencyCode;
        $basket->itemCount           = $basketValueModel->itemCount;

        foreach ($basketValueModel->basketItems as $basketItem) {
            /** @var $basketItem HeidelpayBasketItemAbstractModel */
            $basketItem->amountDiscount = $this->convertPrice($basketItem->amountDiscount);
            $basketItem->amountPerUnit  = $this->convertPrice($basketItem->amountPerUnit);
            $basketItem->amountNet      = $this->convertPrice($basketItem->amountNet);
            $basketItem->amountGross    = $this->convertPrice($basketItem->amountGross);
            $basketItem->amountVat      = $this->convertPrice($basketItem->amountVat);
            $basketItem->description    = substr(strip_tags(nl2br($basketItem->description)), 0, 255);
        }

        $basket->basketItems       = $basketValueModel->basketItems;
        $basket->note              = "";
        $basket->basketReferenceId = $this->getHash($basketValueModel);

        $data->basket = $basket;
        $this->data   = $data;
    }

    /**
     * @param HeidelpayConfigModel $config
     *
     * @return stdClass
     */
    protected function getAuthentication(HeidelpayConfigModel $config)
    {
        $data           = new stdClass();
        $data->login    = $config->login;
        $data->password = $config->password;
        $data->sender   = $config->securitySender;

        return $data;
    }

    /**
     * @param $price
     *
     * @return int
     */
    protected function convertPrice($price)
    {
        return round($price * 100);
    }

    /**
     * @param $object
     *
     * @return string
     */
    public function getHash($object)
    {
        return hash('sha512', serialize($object));
    }

    /**
     * @return string
     */
    public function getJsonObject()
    {
        return json_encode($this->data, JSON_PRETTY_PRINT);
    }
}
