<?php
namespace d3\heidelpay\payment;

use d3\heidelpay\response\Parser;
use d3\heidelpay\request\pattern\PrePayment as PatternPrePayment;
use d3\heidelpay\Redirect;
use ReflectionException;

/**
 * Class Prepayment
 */
class Prepayment extends AbstractPayment
{
    /**
     * {@inheritdoc}
     */
    public function getRequestXmlPattern()
    {
        return new PatternPrePayment();
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentCode()
    {
        return 'PP';
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentTypes()
    {
        return array('PA', 'RC', 'RF');
    }

    /**
     * returns empty array
     *
     * @param Parser $oParser
     *
     * @return array
     */
    public function getDynamicValues(Parser $oParser)
    {
        return array();
    }

    /**
     * @return Redirect
     * @throws ReflectionException
     * @throws exception\UnknownRedirectParameterException
     */
    public function getRedirect()
    {
        return new Redirect();
    }
}
