{*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    D3 Data Development
*  @copyright 2017 D3 Data Development
*  @license   LICENSE.txt
*}
{extends file='checkout/checkout.tpl'}
{block name="content"}
    <section id="content">
        <div class="row">
            <div class="col-md-12">
                <section id="checkout-payment-step" class="checkout-step -current -reachable js-current-step">
                    <h1 class="text-xs-center">{l s='Payment' mod='heidelpay'}</h1>

                    <h2 class="text-xs-center">{l s='Heidelpay payment' mod='heidelpay'}</h2>

                    {include file="module:heidelpay/views/templates/front/error.tpl"}

                    <form action="{$link->getModuleLink('heidelpay', 'ideal', [], true)}"
                          method="post">
                        <div class="row" id="d3HeidelpayPaymentContainer">
                            <div class="col-md-6 offset-md-3">
                                <label>
                                    {l s='please choose your bank' mod='heidelpay'}
                                    <select name="brand">
                                        {foreach from=$brands item='brandName' key='brandIdent'}
                                            <option value="{$brandIdent}">{$brandName}</option>
                                        {/foreach}
                                    </select>
                                </label>
                            </div>
                        </div>

                        <a href="{$link->getPageLink('order', true, NULL, "step=3")}"
                           class="btn btn-default">
                            {l s='Other payment methods' mod='heidelpay'}
                        </a>
                        <button type="submit" id="heidelpayPayNowButton"
                                class="btn btn-primary center-block pull-md-right">
                            {l s='pay now' mod='heidelpay'}
                        </button>
                    </form>
                </section>
            </div>
        </div>
    </section>
{/block}
