{*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    D3 Data Development
*  @copyright 2017 D3 Data Development
*  @license   LICENSE.txt
*}
{extends file='checkout/checkout.tpl'}
{block name="content"}
    <section id="content">
        <div class="row">
            <div class="col-md-12">
                <section id="checkout-payment-step" class="checkout-step -current -reachable js-current-step">
                    <h1 class="text-xs-center">{l s='Payment' mod='heidelpay'}</h1>

                    <h2 class="text-xs-center">{l s='Heidelpay payment' mod='heidelpay'}</h2>

                    {include file="module:heidelpay/views/templates/front/error.tpl"}

                    <form action="{$formularUrl}" method="post">
                        <div class="row" id="d3HeidelpayPaymentContainer">
                            <div class="col-md-6 offset-md-3">
                                <table>
                                    {if $isSepaMode}
                                        <tr>
                                            <td>
                                                <label for="account_bank">BIC:</label>
                                            </td>
                                            <td>
                                                <input id="account_bank" size="20" maxlength="64" name="ACCOUNT.BIC"
                                                       value="" type="text">
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="account_number">IBAN:</label>
                                            </td>
                                            <td>
                                                <input id="account_number" size="20" maxlength="64" name="ACCOUNT.IBAN"
                                                       value="" type="text">
                                            </td>
                                        </tr>
                                    {else}
                                        <tr>
                                            <td>
                                                <label for="account_bank">{l s='Bank' mod='heidelpay'}:</label>
                                            </td>
                                            <td>
                                                <input id="account_bank" size="20" maxlength="64" name="ACCOUNT.BANK"
                                                       value="" type="text">
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="account_number">{l s='Account number' mod='heidelpay'}
                                                    :</label>
                                            </td>
                                            <td>
                                                <input id="account_number" size="20" maxlength="64"
                                                       name="ACCOUNT.NUMBER" value="" type="text">
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <label for="account_country">{l s='Country' mod='heidelpay'}</label>
                                            </td>
                                            <td>
                                                <select id="account_country" name="ADDRESS.COUNTRY">
                                                    <option value="">{l s='Please choose' mod='heidelpay'}:</option>
                                                    {foreach from=$brands item='brandName' key='brandIdent'}
                                                        <option value="{$brandIdent}">{$brandName}</option>
                                                    {/foreach}
                                                </select>
                                            </td>
                                        </tr>
                                    {/if}
                                    <tr>
                                        <td>
                                            <label for="account_holder">{l s='Account holder' mod='heidelpay'}:</label>
                                        </td>
                                        <td>
                                            <input id="account_holder" size="20" maxlength="64" name="ACCOUNT.HOLDER"
                                                   value="" type="text">
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <a href="{$link->getPageLink('order', true, NULL, "step=3")}"
                           class="btn btn-default">
                            {l s='Other payment methods' mod='heidelpay'}
                        </a>
                        <button type="submit" id="heidelpayPayNowButton"
                                class="btn btn-primary center-block pull-md-right">
                            {l s='pay now' mod='heidelpay'}
                        </button>
                    </form>
                </section>
            </div>
        </div>
    </section>
{/block}
