<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2017 D3 Data Development
 * @license   LICENSE.txt
 */

/**
 * This function updates your module from previous versions to the version 1.1,
 * usefull when you modify your database, or register a new hook ...
 * Don't forget to create one file per version.
 *
 * @param heidelpay $module
 *
 * @return bool
 */
function upgrade_module_1_0_2($module)
{
    Configuration::updateValue('HEIDELPAY_SECRET', openssl_random_pseudo_bytes(512));

    return $module->registerHook('DisplayPayment') &&
    $module->unregisterHook('payment') &&
    $module->unregisterHook('paymentReturn');
}
