<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development
 * @support https://heidelpay-presta.shopmodule.com/
 */

namespace d3\heidelpay\request\exception;

use Exception;

class NoPaymentChannelException extends Exception
{
    /**
     * Set a default message for heidelpay exception
     *
     * @param string $sMessage
     * @param int    $iCode
     */
    public function __construct($sMessage = "not set", $iCode = 0)
    {
        if ($sMessage == 'not set') {
            $sMessage = 'No payment channel was provided!';
        }
        parent::__construct($sMessage, $iCode);
    }
}
