<?php
namespace d3\heidelpay\payment;

use d3\heidelpay\response\Parser;
use d3\heidelpay\request\pattern\Creditcard as PatternCreditcard;
use d3\heidelpay\Redirect;
use ReflectionException;

/**
 * Class Creditcard
 */
class Creditcard extends AbstractPayment
{
    /**
     * {@inheritdoc}
     */
    public function getRequestXmlPattern()
    {
        return new PatternCreditcard();
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentCode()
    {
        return 'CC';
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentTypes()
    {
        return array('RG', 'PA', 'DB', 'CP', 'RF', 'RB');
    }

    /**
     * Returns card data from parser.
     *
     * @param Parser $oParser
     *
     * @return array
     */
    public function getDynamicValues(Parser $oParser)
    {
        return $oParser->getCardData();
    }

    /**
     * @return Redirect
     * @throws ReflectionException
     * @throws exception\UnknownRedirectParameterException
     */
    public function getRedirect()
    {
        return new Redirect();
    }
}
