<?php
/**
 * NOTICE OF LICENSE
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2017 D3 Data Development
 * @license   LICENSE.txt
 */

ini_set('error_reporting', E_ALL ^ E_NOTICE);

use d3\heidelpay\blowfish\Blowfish;
use d3\heidelpay\transactionlog\reader\Transaction;

require_once(dirname(__FILE__).'/heidelpay.php'); // Base Controller

/**
 * 2007-2015 PrestaShop
 * NOTICE OF LICENSE
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 * DISCLAIMER
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2015 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *            International Registered Trademark & Property of PrestaShop SA
 */
class HeidelpayValidationModuleFrontController extends ModuleFrontController
{
    /**
     * @var bool
     */
    public $display_column_left = false;

    /**
     * @var bool
     */
    public $display_column_right = false;

    /** @var PaymentModule */
    public $module;

    /**
     * @var
     */
    protected $redirectUrl;

    /**
     * This class should be use by your Instant Payment
     * Notification system to validate the order remotely
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function postProcess()
    {
        /**
         * If the module is not active anymore, no need to process anything.
         */
        if ($this->module->active == false) {
            return;
        }

        $currentTransactionId = Tools::getValue('currenttransactionid');
        if (false == $currentTransactionId) {
            $message = $this->module->getTranslator()->trans('An error occurred while processing payment');
            $this->context->smarty->assign('errors', array($message."::".__LINE__));
            $this->setTemplate("module:heidelpay/views/templates/front/errorpage.tpl");

            return;
        }

        // validate transaction
        if ($currentTransactionId //
            && HeidelpayTransactionModel::existsInDatabase($currentTransactionId, "heidelpayTransactions")
        ) {
            $blowFish        = new Blowfish(HeidelpayModuleFrontController::BLOFISH_KEY);
            $activeRecord    = new HeidelpayTransactionModel($currentTransactionId);
            $transactionData = $this->decode($blowFish->decrypt($activeRecord->transaction_data));

            $transaction = new Transaction();
            $transaction->read($transactionData);

            if (false == $this->isHashValid($transactionData)) {
                $message = $this->module->getTranslator()->trans('An error occurred while processing payment');
                $this->context->smarty->assign('errors', array($message."::".__LINE__));
                $this->setTemplate("module:heidelpay/views/templates/front/errorpage.tpl");

                return;
            }

            if ($transaction->getResult() === 'NOK') {
                //error payment
                $message = $this->module->getTranslator()->trans($transaction->getReturncode());
                $this->context->smarty->assign('errors', array($message."::".__LINE__));
                $this->setTemplate("module:heidelpay/views/templates/front/errorpage.tpl");

                return;
            }

            if ($this->context->customer->id != $activeRecord->id_customer) {
                //error user wrong
                $message = $this->module->getTranslator()->trans('An error occurred while processing payment');
                $this->context->smarty->assign('errors', array($message."::".__LINE__));
                $this->setTemplate("module:heidelpay/views/templates/front/errorpage.tpl");

                return;
            }

            $paymentMethod = $this->module->displayName;

            if (isset($transactionData['CRITERION_SESSION']) && strstr($transactionData['CRITERION_SESSION'], '__@@')) {
                $sessionData   = explode('__@@', $transactionData['CRITERION_SESSION']);
                $paymentMethod = $this->module->l($sessionData[0]);
            }

            /**
             * Since it is an example, we choose sample data,
             * You'll have to get the correct values :)
             */
            $cart_id     = $this->context->cart->id;
            $customer_id = $this->context->cart->id_customer;
            $amount      = $transaction->getAmount();

            /**
             * Restore the context from the $cart_id & the $customer_id to process the validation properly.
             */
            Context::getContext()->cart     = new Cart((int)$cart_id);
            Context::getContext()->customer = new Customer((int)$customer_id);
            Context::getContext()->currency = new Currency((int)Context::getContext()->cart->id_currency);
            Context::getContext()->language = new Language((int)Context::getContext()->customer->id_lang);

            $secure_key     = Context::getContext()->customer->secure_key;
            $payment_status = Configuration::get('PS_OS_ERROR');

            if ($this->isValidOrder() === true) {
                $payment_status = Configuration::get('PS_OS_PAYMENT');
            }

            if ($this->isPaymentIncomplete($transaction)) {
                $payment_status = Configuration::get('HEIDELPAY_STATE_WAITING');
            }

            if ('PP.PA' == $transaction->getPaymentcode()) {
                $amount = 0;
            }

            if ($this->module->validateOrder(
                $cart_id,
                $payment_status,
                $amount,
                $paymentMethod,
                null,
                array('transaction_id' => $transaction->getShortid()),
                null,
                false,
                Context::getContext()->customer->secure_key
            )
            ) {
                $activeRecord->id_transactiongroup = $this->module->currentOrder;
                $activeRecord->save();

                if ('PP.PA' == $transaction->getPaymentcode()
                    || Configuration::get('HEIDELPAY_STATE_WAITING') === $payment_status
                ) {
                    $order = new Order($this->module->currentOrder);
                    $order->addOrderPayment($amount, $paymentMethod, $transaction->getShortid());
                }

                Tools::redirect(
                    'index.php?controller=order-confirmation&id_cart='//
                    .Context::getContext()->cart->id.'&id_module='.$this->module->id.'&id_order='//
                    .$this->module->currentOrder.'&key='.$secure_key
                );
            }
        }

        $message = $this->module->getTranslator()->trans('An error occurred while processing payment');
        $this->context->smarty->assign('errors', array($message."::".__LINE__));
        $this->setTemplate("module:heidelpay/views/templates/front/errorpage.tpl");
    }

    /**
     * @param $parameter
     *
     * @return mixed
     */
    public function decode($parameter)
    {
        return json_decode($parameter, true);
    }

    /**
     * @param $response
     *
     * @return bool
     */
    public function isHashValid($response)
    {
        $predefinedKeys = array(
            'CRITERION_HASH'               => '',
            'CRITERION_SESSION'            => '',
            'IDENTIFICATION_TRANSACTIONID' => '',
            'PRESENTATION_AMOUNT'          => '',
            'PRESENTATION_CURRENCY'        => '',
            'TRANSACTION_CHANNEL'          => '',
        );

        $response = array_merge($predefinedKeys, $response);

        $sOriginalHash = $response['CRITERION_HASH'];

        $stringToHash = Configuration::get('HEIDELPAY_SECRET', null);
        $stringToHash .= $response['CRITERION_SESSION'];
        $stringToHash .= $response['IDENTIFICATION_TRANSACTIONID'];
        $stringToHash .= $response['PRESENTATION_AMOUNT'];
        $stringToHash .= $response['PRESENTATION_CURRENCY'];
        $stringToHash .= $response['TRANSACTION_CHANNEL'];
        $ascii        = bin2hex($stringToHash);
        $sCheckHash   = sha1($ascii);

        return $sCheckHash === $sOriginalHash;
    }

    /**
     * @return bool
     */
    protected function isValidOrder()
    {
        /**
         * Add your checks right there
         */
        return true;
    }

    /**
     * @param Transaction $transaction
     *
     * @return bool
     */
    protected function isPaymentIncomplete(Transaction $transaction)
    {
        return 'IV.PA' == $transaction->getPaymentcode()
            || 'CC.PA' == $transaction->getPaymentcode()
            || 'DD.PA' == $transaction->getPaymentcode()
            || 'VA.PA' == $transaction->getPaymentcode()
            || 'DC.PA' == $transaction->getPaymentcode()
            || 'PP.PA' == $transaction->getPaymentcode();
    }

    /**
     * @param $parameter
     *
     * @return string
     */
    public function encode($parameter)
    {
        return json_encode($parameter);
    }
}
