{*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    D3 Data Development
*  @copyright 2017 D3 Data Development
*  @license   LICENSE.txt
*}
{extends file='checkout/checkout.tpl'}
{block name="content"}
    <section id="content">
        <div class="row">
            <div class="col-md-12">
                <section id="checkout-payment-step" class="checkout-step -current -reachable js-current-step">
                    <h1 class="text-xs-center">{l s='Payment' mod='heidelpay'}</h1>

                    <h2 class="text-xs-center">{l s='Heidelpay payment' mod='heidelpay'}</h2>

                    {if not empty($errors)}
                        {include file="module:heidelpay/views/templates/front/error.tpl"}
                    {/if}

                    <form id="d3HeidelpayPaymentForm">
                        {*we need a bunch of parameters here*}
                        {foreach from=$formularParameters item='value' key='name' name='heidepayParameters'}
                            <input type="hidden" name="{$name}" value="{$value}"/>
                        {/foreach}

                        <div class="row" id="d3HeidelpayPaymentContainer">
                            <div class="col-md-6 offset-md-3">
                                <iframe id="paymentFrameIframe" src="{$iframeUrl}"
                                        frameborder="0" scrolling="no">
                                    Your Browser doesn\'t support iFrames
                                </iframe>
                            </div>
                        </div>
                        <a href="{$link->getPageLink('order', true, NULL, "step=3")}"
                           class="btn btn-default">
                            {l s='Other payment methods' mod='heidelpay'}
                        </a>
                        <button type="submit" id="heidelpayPayNowButton"
                                class="btn btn-primary center-block pull-md-right">
                            {l s='pay now' mod='heidelpay'}
                        </button>
                    </form>
                    <script type="text/javascript">
                        var targetOrigin = getDomainFromUrl('{$iframeUrl}');

                        // ### Sending postMessages ###
                        var paymentFrameForm = document.getElementById('d3HeidelpayPaymentForm');
                        var paymentFrameIframe = document.getElementById('paymentFrameIframe');

                        // Add an event listener that will execute the sendMessage() function
                        // when the send button is clicked.
                        if (paymentFrameForm.addEventListener) { // W3C DOM
                            paymentFrameForm.addEventListener('submit', sendMessage);
                        } else if (paymentFrameForm.attachEvent) { // IE DOM
                            paymentFrameForm.attachEvent('onsubmit', sendMessage);
                        }
                        // A function to handle sending messages.
                        function sendMessage(e) {
                            // Prevent any default browser behaviour.
                            if (e.preventDefault) {
                                e.preventDefault();
                            } else {
                                e.returnValue = false;
                            }

                            // save the form data in an object
                            var data = {};
                            for (var i = 0, len = paymentFrameForm.length; i < len; ++i) {
                                var input = paymentFrameForm[i];
                                if (input.name) {
                                    data[input.name] = input.value;
                                }
                            }
                            {if $isHeidelpayDebugMode}
                            console.log(targetOrigin);
                            console.log(data);
                            {/if}

                            // Send a json message with the form data to the iFrame receiver window.
                            paymentFrameIframe.contentWindow.postMessage(JSON.stringify(data), targetOrigin);
                        }

                        // ### Utils ###
                        // extract protocol, domain and port from url
                        function getDomainFromUrl(url) {
                            var arr = url.split("/");
                            return arr[0] + "//" + arr[2];
                        }

                        {if $isHeidelpayDebugMode}
                        // Setup an event listener that calls receiveMessage() when the window
                        // receives a new MessageEvent.
                        if (window.addEventListener) {  // W3C DOM
                            window.addEventListener('message', receiveMessage);
                        } else if (window.attachEvent) { // IE DOM
                            window.attachEvent('onmessage', receiveMessage);
                        }
                        // ### Receiving postMessages ###
                        function receiveMessage(e) {
// Check to make sure that this message came from the correct domain.
                            if (e.origin !== targetOrigin) {
                                return;
                            }
// Do something with the data
                            console.log(e.data);
                        }
                        {/if}

                    </script>
                </section>
            </div>
        </div>
    </section>
{/block}
