<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2017 D3 Data Development
 * @license   LICENSE.txt
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * This function updates your module from previous versions to the version 1.1,
 * usefull when you modify your database, or register a new hook ...
 * Don't forget to create one file per version.
 *
 * @return bool
 * @throws PrestaShopDatabaseException
 * @throws PrestaShopException
 */
function upgrade_module_1_0_6()
{
    if (false == Configuration::get('HEIDELPAY_STATE_WAITING')) {
        $orderState       = new OrderState();
        $orderState->name = array();

        foreach (Language::getLanguages() as $language) {
            if (Tools::strtolower($language['iso_code']) == 'de') {
                $orderState->name[$language['id_lang']] = 'Warten auf Bezahlung (Heidelpay)';
            } else {
                $orderState->name[$language['id_lang']] = 'waiting for payment (heidelpay)';
            }
        }

        $orderState->send_email  = false;
        $orderState->color       = '#4169E1';
        $orderState->hidden      = false;
        $orderState->module_name = 'heidelpay';
        $orderState->delivery    = false;
        $orderState->logable     = false;
        $orderState->invoice     = false;
        $orderState->unremovable = true;
        $orderState->add();

        return Configuration::updateValue('HEIDELPAY_STATE_WAITING', (int)$orderState->id);
    }

    return false;
}
