<?php
/**
 * NOTICE OF LICENSE
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2017 D3 Data Development
 * @license   LICENSE.txt
 */

require_once('HeidelpayBasketItemAbstractModel.php');

/**
 * Class HeidelpayGiftWrappingValueModel
 */
class HeidelpayGiftWrappingValueModel extends HeidelpayBasketItemAbstractModel
{
    public function __construct(array $giftWrappingData, $position)
    {
        $this->position              = $position;
        $this->basketItemReferenceId = hash('sha512', serialize($giftWrappingData));
        $this->unit                  = "";
        $this->quantity              = 1;
        $this->amountDiscount        = 0;
        $this->vat                   = $this->getVatValue(
            $giftWrappingData['priceWithTax'],
            $giftWrappingData['priceWithTax']
        );
        $this->amountPerUnit         = $giftWrappingData['priceWithTax'];
        $this->amountNet             = $giftWrappingData['priceWithoutTax'];
        $this->amountGross           = $giftWrappingData['priceWithTax'];
        $this->amountVat             = $giftWrappingData['priceWithTax'] - $giftWrappingData['priceWithTax'];
        $this->articleId             = '';
        $this->type                  = 'goods';
        $this->title                 = 'Gift';
        $this->description           = '';
        $this->imageUrl              = '';
    }
}
