<?php
namespace d3\heidelpay\actions;

use Exception;

/**
 * Class AbstractAction
 */
abstract class AbstractAction
{
    /**
     * @var string
     */
    protected $paymentCode = "";

    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $value;

    /**
     * @param $sPaymentCode
     *
     * @throws Exception
     */
    public function __construct($sPaymentCode)
    {
        if (false == is_string($sPaymentCode)) {
            throw new Exception('Paymentcode is not a string!');
        }
        $this->paymentCode = $sPaymentCode;
    }

    /**
     * @return string
     */
    public function getPaymentCode()
    {
        return $this->paymentCode;
    }

    /**
     * @return bool
     */
    abstract public function isDisabled();

    /**
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
}
