<?php
/**
 * NOTICE OF LICENSE
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2017 D3 Data Development
 * @license   LICENSE.txt
 */

require_once('HeidelpayBasketItemAbstractModel.php');

/**
 * Class HeidelpayCartRuleValueModel
 */
class HeidelpayCartRuleValueModel extends HeidelpayBasketItemAbstractModel
{
    public function __construct(array $cartRuleData, $position)
    {
        $this->position              = $position;
        $this->basketItemReferenceId = hash('sha512', serialize($cartRuleData));
        $this->unit                  = "";
        $this->quantity              = 1;
        $this->amountDiscount        = 0;
        $this->vat                   = $this->getVatValue($cartRuleData['value_real'], $cartRuleData['value_tax_exc']);
        $this->amountPerUnit         = $cartRuleData['value_real'];
        $this->amountNet             = $cartRuleData['value_tax_exc'];
        $this->amountGross           = $cartRuleData['value_real'];
        $this->amountVat             = $cartRuleData['value_real'] - $cartRuleData['value_tax_exc'];
        $this->articleId             = $cartRuleData['id_cart_rule'];
        $this->type                  = 'voucher';
        $this->title                 = $cartRuleData['name'];
        $this->description           = $cartRuleData['obj']->description;
        $this->imageUrl              = '';
    }
}
