<?php
/**
 * NOTICE OF LICENSE
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2017 D3 Data Development
 * @license   LICENSE.txt
 */

/**
 * Class HeidelpayBasketItemAbstractModel
 */
abstract class HeidelpayBasketItemAbstractModel
{
    public $position;

    public $basketItemReferenceId;

    public $imageUrl;

    public $unit;

    public $quantity;

    public $amountDiscount;

    public $vat;

    public $amountPerUnit;

    public $amountNet;

    public $amountGross;

    public $amountVat;

    public $articleId;

    public $type;

    public $title;

    public $description;

    protected function getVatValue($withTax, $withoutTax)
    {
        if ($withoutTax == 0) {
            return 0;
        }

        return ($withTax - $withoutTax) * 100 / $withoutTax;
    }
}
