<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development
 * @support https://addons.prestashop.com/de/contact-us?id_product=21584
 */

namespace d3\heidelpay\request;

use d3\heidelpay\settings\exception\emptypasswordexception;
use d3\heidelpay\settings\exception\emptysecuritysenderexception;
use d3\heidelpay\settings\exception\emptyusernameexception;

/**
 * Class Config
 *
 * @package d3\heidelpay\request
 */
class Config
{
    /**
     *
     */
    const TRANSACTION_MODE_TEST = "CONNECTOR_TEST";

    /**
     *
     */
    const TRANSACTION_MODE_LIVE = "LIVE";

    /** @var  string */
    protected $responseUrl;

    /** @var  bool */
    protected $isTestmode = true;

    /** @var  string */
    protected $remoteAddress;

    /** @var  string */
    protected $securitySender;

    /** @var  string */
    protected $userId;

    /** @var  string */
    protected $password;

    /** @var  string */
    protected $testErrorCode;

    /** @var  string */
    protected $testReturnCode;

    /** @var string */
    protected $notifyUrl;

    /**
     * Config constructor.
     *
     * @param array $properties
     */
    public function __construct(array $properties = array())
    {
        foreach ($properties as $propertyName => $propertyvalue) {
            $this->{$propertyName} = $propertyvalue;
        }
    }

    /**
     * @return string
     */
    public function getTestErrorCode()
    {
        return $this->testErrorCode;
    }

    /**
     * @param string $testErrorCode
     */
    public function setTestErrorCode($testErrorCode)
    {
        $this->testErrorCode = $testErrorCode;
    }

    /**
     * @return string
     */
    public function getTestReturnCode()
    {
        return $this->testReturnCode;
    }

    /**
     * @param string $testReturnCode
     */
    public function setTestReturnCode($testReturnCode)
    {
        $this->testReturnCode = $testReturnCode;
    }

    /**
     * @return string
     */
    public function getResponseUrl()
    {
        return $this->responseUrl;
    }

    /**
     * @param string $responseUrl
     */
    public function setResponseUrl($responseUrl)
    {
        $this->responseUrl = $responseUrl;
    }

    /**
     * @return string
     */
    public function getRemoteAddress()
    {
        return $this->remoteAddress;
    }

    /**
     * @param string $remoteAddress
     */
    public function setRemoteAddress($remoteAddress)
    {
        $this->remoteAddress = $remoteAddress;
    }

    /**
     * @return string
     */
    public function getTransactionMode()
    {
        if ($this->isTestmode()) {
            return self::TRANSACTION_MODE_TEST;
        }

        return self::TRANSACTION_MODE_LIVE;
    }

    /**
     * @return bool
     */
    public function isTestmode()
    {
        return $this->isTestmode;
    }

    /**
     * @param boolean $isTestmode
     */
    public function setIsTestmode($isTestmode)
    {
        $this->isTestmode = $isTestmode;
    }

    /**
     * @return string
     * @throws emptysecuritysenderexception
     */
    public function getSecuritySender()
    {
        if (empty($this->securitySender)) {
            $oEx = new emptysecuritysenderexception();
            throw $oEx;
        }

        return $this->securitySender;
    }

    /**
     * @param string $securitySender
     */
    public function setSecuritySender($securitySender)
    {
        $this->securitySender = $securitySender;
    }

    /**
     * @return string
     * @throws emptyusernameexception
     */
    public function getUserID()
    {
        if (empty($this->userId)) {
            $oEx = new emptyusernameexception();
            throw $oEx;
        }

        return $this->userId;
    }

    /**
     * @param string $userId
     */
    public function setUserId($userId)
    {
        $this->userId = $userId;
    }

    /**
     * @return string
     * @throws emptypasswordexception
     */
    public function getPassword()
    {
        if (empty($this->password)) {
            $oEx = new emptypasswordexception();
            throw $oEx;
        }

        return $this->password;
    }

    /**
     * @param string $password
     */
    public function setPassword($password)
    {
        $this->password = $password;
    }

    /**
     * @return string
     */
    public function getNotifyUrl()
    {
        return $this->notifyUrl;
    }

    /**
     * @param string $notifyUrl
     *
     * @return Config
     */
    public function setNotifyUrl($notifyUrl)
    {
        $this->notifyUrl = $notifyUrl;

        return $this;
    }
}
