<?php
namespace d3\heidelpay\payment\data;

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
  *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development
 * @support:      https://addons.prestashop.com/de/contact-us?id_product=21584
 */
class Position
{

    /** @var  string */
    protected $percentVat;

    /** @var  int */
    protected $amountUnitGross;

    /** @var  int */
    protected $amountGross;

    /** @var  string */
    protected $type;

    /** @var  string */
    protected $number;

    /** @var  string */
    protected $text;

    /** @var  string */
    protected $unit;

    /** @var  string */
    protected $quantity;

    public function __construct(array $properties = array())
    {
        foreach ($properties as $propertyName => $propertyvalue) {
            $this->{$propertyName} = $propertyvalue;
        }
    }

    /**
     * @return mixed
     */
    public function getPercentVat()
    {
        return $this->percentVat;
    }

    /**
     * @param mixed $percentVat
     */
    public function setPercentVat($percentVat)
    {
        $this->percentVat = $percentVat;
    }

    /**
     * @return mixed
     */
    public function getAmountUnitGross()
    {
        return $this->amountUnitGross;
    }

    /**
     * @param mixed $amountUnitGross
     */
    public function setAmountUnitGross($amountUnitGross)
    {
        $this->amountUnitGross = $amountUnitGross;
    }

    /**
     * @return mixed
     */
    public function getAmountGross()
    {
        return $this->amountGross;
    }

    /**
     * @param mixed $amountGross
     */
    public function setAmountGross($amountGross)
    {
        $this->amountGross = $amountGross;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param mixed $type
     */
    public function setType($type)
    {
        $this->type = $type;
    }

    /**
     * @return mixed
     */
    public function getNumber()
    {
        return $this->number;
    }

    /**
     * @param mixed $number
     */
    public function setNumber($number)
    {
        $this->number = $number;
    }

    /**
     * @return mixed
     */
    public function getText()
    {
        return $this->text;
    }

    /**
     * @param mixed $text
     */
    public function setText($text)
    {
        $this->text = $text;
    }

    /**
     * @return mixed
     */
    public function getUnit()
    {
        return $this->unit;
    }

    /**
     * @param mixed $unit
     */
    public function setUnit($unit)
    {
        $this->unit = $unit;
    }

    /**
     * @return mixed
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param mixed $quantity
     */
    public function setQuantity($quantity)
    {
        $this->quantity = $quantity;
    }
}
