<?php
namespace d3\heidelpay\payment;

use d3\heidelpay\request\pattern\OnlineTransfer;
use d3\heidelpay\response\Parser;
use d3\heidelpay\Redirect;
use ReflectionException;

/**
 * Class Paypal
 */
class Paypal extends AbstractPayment
{
    /**
     * {@inheritdoc}
     */
    public function getRequestXmlPattern()
    {
        return new OnlineTransfer();
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentCode()
    {
        return 'VA';
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentTypes()
    {
        return array('PA', 'DB', 'CP', 'RF');
    }

    /**
     * returns empty array
     *
     * @param Parser $oParser
     *
     * @return array
     */
    public function getDynamicValues(Parser $oParser)
    {
        return array();
    }

    /**
     * @return Redirect
     * @throws ReflectionException
     * @throws exception\UnknownRedirectParameterException
     */
    public function getRedirect()
    {
        return new Redirect();
    }
}
