<?php
namespace d3\heidelpay\payment;

use d3\heidelpay\request\pattern\Debitcard as PatternDebitcard;
use d3\heidelpay\response\Parser;
use d3\heidelpay\Redirect;
use ReflectionException;

/**
 * Class Debitcard
 */
class Debitcard extends AbstractPayment
{
    /**
     * {@inheritdoc}
     */
    public function getRequestXmlPattern()
    {
        return new PatternDebitcard();
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentCode()
    {
        return 'DC';
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentTypes()
    {
        return array('RG', 'PA', 'DB', 'CP', 'RF', 'RB');
    }

    /**
     * Returns card data from parser.
     *
     * @param Parser $oParser
     *
     * @return array
     */
    public function getDynamicValues(Parser $oParser)
    {
        return $oParser->getCardData();
    }

    /**
     * @return Redirect
     * @throws ReflectionException
     * @throws exception\UnknownRedirectParameterException
     */
    public function getRedirect()
    {
        return new Redirect();
    }
}
