<?php

namespace d3\heidelpay;

use d3\heidelpay\ngw\Request;

/**
 * Class Ngw
 *
 * @package d3\heidelpay
 */
class Ngw
{
    const XML = 'XML';
    const POST = 'POST';
    const JSON = 'JSON';
    protected $curlError;

    /**
     * @return mixed
     */
    public function getCurlError()
    {
        return $this->curlError;
    }

    /**
     * Build up and returns curl ressource
     *
     * @param Request $request
     *
     * @return array
     */
    public function sendXMLRequest(request $request)
    {
        //remove whitespaces, without destroying xml
        $data = preg_replace('@>\s*<@', '><', $request->getData());
        $curl = $this->setupCurl($request, 'load=' . urlencode($data));

        $responseData = $this->excecuteCurl($curl);

        return $responseData;
    }

    /**
     * @param Request $request
     * @param mixed  $data
     *
     * @param string  $type
     *
     * @return resource
     */
    protected function setupCurl(request $request, $data, $type = self::POST)
    {
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_TIMEOUT, $request->getCurlTimeOut());
        curl_setopt($curl, CURLOPT_URL, $request->getUrl());
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);

        if ($type === self::JSON) {
            curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json;charset=UTF-8'));
        }

        return $curl;
    }

    /**
     * @param $curl
     *
     * @return mixed
     */
    protected function excecuteCurl($curl)
    {
        $response = curl_exec($curl);

        if (curl_errno($curl) || $response === false) {
            $this->curlError = curl_error($curl);
        }
        curl_close($curl);

        return $response;
    }

    /**
     * @param Request $request
     *
     * @return array
     */
    public function sendPostRequest(Request $request)
    {
        $curl = $this->setupCurl($request, http_build_query($request->getData()));

        $response = $this->excecuteCurl($curl);

        //TODO error handling
        if ($response === false) {
            return array();
        }

        parse_str($response, $responseData);
        foreach ($responseData as $key => $value) {
            $responseData[$key] = stripslashes($value);
        }

        return $responseData;
    }

    /**
     * @param Request $request
     *
     * @return array
     */
    public function sendJSONRequest(Request $request)
    {
        $curl = $this->setupCurl($request, $request->getData(), self::JSON);

        $response = $this->excecuteCurl($curl);

        //TODO error handling
        if ($response === false) {
            return array();
        }

        return $response;
    }
}
