{*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    D3 Data Development
*  @copyright 2016 D3 Data Development
*  @license   LICENSE.txt
*}
{capture name=path}
    <a href="{$link->getPageLink('order', true, NULL, "step=3")|escape:'html':'UTF-8'}"
       title="{l s='Go back to the checkout' mod='heidelpay'}">{l s='Checkout' mod='heidelpay'}</a>
    <span class="navigation-pipe">{$navigationPipe|escape:'html':'UTF-8'}</span>{l s='Heidelpay payment' mod='heidelpay'}
{/capture}

<h1 class="page-heading">{l s='Payment' mod='heidelpay'}</h1>

{assign var='current_step' value='payment'}
{include file="$tpl_dir./order-steps.tpl"}

<h2 class="page-subheading">{l s='Heidelpay payment' mod='heidelpay'}</h2>
{if $error_tpl}
    {include file=$error_tpl hideOrderSteps=true}
{/if}

<form id="paymentFrameForm">
    {*we need a bunch of parameters here*}
    {foreach from=$formularParameters item='value' key='name' name='heidepayParameters'}
        <input type="hidden" name="{$name|escape:'htmlall':'UTF-8'}" value="{$value|escape:'htmlall':'UTF-8'}"/>
    {/foreach}

    <div class="box clearfix">
        <iframe id="paymentFrameIframe" src="{$iframeUrl|escape:'html':'UTF-8'}"
                frameborder="0" scrolling="no">
            Your Browser doesn\'t support iFrames
        </iframe>
    </div>
    <p class="cart_navigation clearfix">
        <a href="{$link->getPageLink('order', true, NULL, "step=3")|escape:'html':'UTF-8'}"
           class="button-exclusive btn btn-default">
            <i class="icon-chevron-left"></i>{l s='Other payment methods' mod='heidelpay'}
        </a>
        <button type="submit" id="heidelpayPayNowButton"
                class="button btn btn-default standard-checkout button-medium">
            <span>
                {l s='pay now' mod='heidelpay'}
                <i class="icon-chevron-right right"></i>
            </span>
        </button>
    </p>
</form>
<script type="text/javascript">
    var targetOrigin = getDomainFromUrl('{$iframeUrl|escape:'html':'UTF-8'}');

    // ### Sending postMessages ###
    var paymentFrameForm = document.getElementById('paymentFrameForm');
    var paymentFrameIframe = document.getElementById('paymentFrameIframe');

    // Add an event listener that will execute the sendMessage() function
    // when the send button is clicked.
    if (paymentFrameForm.addEventListener) { // W3C DOM
        paymentFrameForm.addEventListener('submit', sendMessage);
    } else if (paymentFrameForm.attachEvent) { // IE DOM
        paymentFrameForm.attachEvent('onsubmit', sendMessage);
    }
    // A function to handle sending messages.
    function sendMessage(e) {
        // Prevent any default browser behaviour.
        if (e.preventDefault) {
            e.preventDefault();
        } else {
            e.returnValue = false;
        }

        // save the form data in an object
        var data = { };
        for (var i = 0, len = paymentFrameForm.length; i < len; ++i) {
            var input = paymentFrameForm[i];
            if (input.name) {
                data[input.name] = input.value;
            }
        }
        {if $isHeidelpayDebugMode}
        console.log(targetOrigin);
        console.log(data);
        {/if}

        // Send a json message with the form data to the iFrame receiver window.
        paymentFrameIframe.contentWindow.postMessage(JSON.stringify(data), targetOrigin);
    }

    // ### Utils ###
    // extract protocol, domain and port from url
    function getDomainFromUrl(url) {
        var arr = url.split("/");
        return arr[0] + "//" + arr[2];
    }

    {if $isHeidelpayDebugMode}
    // Setup an event listener that calls receiveMessage() when the window
    // receives a new MessageEvent.
    if (window.addEventListener) {  // W3C DOM
        window.addEventListener('message', receiveMessage);
    } else if (window.attachEvent) { // IE DOM
        window.attachEvent('onmessage', receiveMessage);
    }
    // ### Receiving postMessages ###
    function receiveMessage(e) {
// Check to make sure that this message came from the correct domain.
        if (e.origin !== targetOrigin) {
            return;
        }
// Do something with the data
        console.log(e.data);
    }
    {/if}

</script>
