{*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    D3 Data Development
*  @copyright 2016 D3 Data Development
*  @license   LICENSE.txt
*}
{capture name=path}
    <a href="{$link->getPageLink('order', true, NULL, "step=3")|escape:'html':'UTF-8'}"
       title="{l s='Go back to the checkout' mod='heidelpay'}">{l s='Checkout' mod='heidelpay'}</a>
    <span class="navigation-pipe">{$navigationPipe|escape:'html':'UTF-8'}</span>{l s='Heidelpay payment' mod='heidelpay'}
{/capture}

<h1 class="page-heading">{l s='Payment' mod='heidelpay'}</h1>

{assign var='current_step' value='payment'}
{include file="$tpl_dir./order-steps.tpl"}

<h2 class="page-subheading">{l s='Heidelpay payment' mod='heidelpay'}</h2>
{if $error_tpl}
    {include file=$error_tpl hideOrderSteps=true}
{/if}

<form id="paymentFrameForm" action="{$formularUrl|escape:'htmlall':'UTF-8'}" method="post">
    <div class="box clearfix">
        <table id="paymentFormular">
            {if $isSepaMode}
                <tr>
                    <td>
                        <label for="account_bank">BIC:</label>
                    </td>
                    <td>
                        <input id="account_bank" size="20" maxlength="64" name="ACCOUNT.BIC" value="" type="text">
                    </td>
                </tr>
                <tr>
                    <td>
                        <label for="account_number">IBAN:</label>
                    </td>
                    <td>
                        <input id="account_number" size="20" maxlength="64" name="ACCOUNT.IBAN" value="" type="text">
                    </td>
                </tr>
            {else}
                <tr>
                    <td>
                        <label for="account_bank">{l s='Bank' mod='heidelpay'}:</label>
                    </td>
                    <td>
                        <input id="account_bank" size="20" maxlength="64" name="ACCOUNT.BANK" value="" type="text">
                    </td>
                </tr>
                <tr>
                    <td>
                        <label for="account_number">{l s='Account number' mod='heidelpay'}:</label>
                    </td>
                    <td>
                        <input id="account_number" size="20" maxlength="64" name="ACCOUNT.NUMBER" value="" type="text">
                    </td>
                </tr>
                <tr>
                    <td>
                        <label for="account_country">{l s='Country' mod='heidelpay'}</label>
                    </td>
                    <td>
                        <select id="account_country" name="ACCOUNT.COUNTRY">
                            <option value="">{l s='Please choose' mod='heidelpay'}:</option>
                            {foreach from=$brands item='brandName' key='brandIdent'}
                                <option value="{$brandIdent|escape:'htmlall':'UTF-8'}">{$brandName|escape:'htmlall':'UTF-8'}</option>
                            {/foreach}
                        </select>
                    </td>
                </tr>
            {/if}
            <tr>
                <td>
                    <label for="account_holder">{l s='Account holder' mod='heidelpay'}:</label>
                </td>
                <td>
                    <input id="account_holder" size="20" maxlength="64" name="ACCOUNT.HOLDER" value="" type="text">
                </td>
            </tr>
        </table>
    </div>
    <p class="cart_navigation clearfix">
        <a href="{$link->getPageLink('order', true, NULL, "step=3")|escape:'html':'UTF-8'}"
           class="button-exclusive btn btn-default">
            <i class="icon-chevron-left"></i>{l s='Other payment methods' mod='heidelpay'}
        </a>
        <button type="submit" id="heidelpayPayNowButton"
                class="button btn btn-default standard-checkout button-medium">
            <span>
                {l s='pay now' mod='heidelpay'}
                <i class="icon-chevron-right right"></i>
            </span>
        </button>
    </p>
</form>
