<?php
namespace d3\heidelpay\payment;

use d3\heidelpay\Redirect;
use d3\heidelpay\request\pattern\OnlineTransfer;
use d3\heidelpay\response\Parser;

/**
 * Class Eps
 */
class Eps extends AbstractPayment
{
    /**
     * {@inheritdoc}
     */
    public function getRequestXmlPattern()
    {
        return new OnlineTransfer();
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentCode()
    {
        return 'OT';
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentTypes()
    {
        return array('PA', 'RC');
    }

    /**
     * returns empty array
     *
     * @param Parser $oParser
     *
     * @return array
     */
    public function getDynamicValues(Parser $oParser)
    {
        return array();
    }

    /**
     * @return redirect
     */
    public function getRedirect()
    {
        return new redirect();
    }
}
