<?php
namespace d3\heidelpay\payment;

use d3\heidelpay\Redirect;
use d3\heidelpay\request\pattern\OnlineTransfer;
use d3\heidelpay\response\Parser;

/**
 * Class Billsafe
 */
class Billsafe extends AbstractPayment
{
    /**
     * {@inheritdoc}
     */
    public function getRequestXmlPattern()
    {
        return new OnlineTransfer();
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentCode()
    {
        return 'IV';
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentTypes()
    {
        return array('PA', 'FI', 'RC', 'RF');
    }

    /**
     * Returns empty array
     *
     * @param Parser $oParser
     *
     * @return array
     */
    public function getDynamicValues(Parser $oParser)
    {
        return array();
    }

    /**
     * @return redirect
     */
    public function getRedirect()
    {
        return new redirect();
    }
}
