<?php
namespace d3\heidelpay;

use d3\heidelpay\payment\exception\UnknownRedirectParameterException;

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author        D3 Data Development <support@shopmodule.com>
 * @link          http://www.oxidmodule.com
 */
class Redirect
{
    const REDIRECT_TYPE_GET = "GET";
    const REDIRECT_TYPE_POST = "POST";
    const REDIRECT_TYPE_NONE = "NONE";

    /**
     * @param string $sType
     *
     * @throws UnknownRedirectParameterException
     */
    public function __construct($sType = self::REDIRECT_TYPE_NONE)
    {
        $oReflectionClass = new \ReflectionClass('redirect');
        if (false == in_array($sType, $oReflectionClass->getConstants())) {
            $oException = new UnknownRedirectParameterException($sType);
            throw $oException;
        }
        $this->sRedirectType = $sType;
    }

    /**
     * @return string POST/GET
     */
    public function getRedirectType()
    {
        return $this->sRedirectType;
    }
}
