<?php
namespace d3\heidelpay;

use d3\heidelpay\ngw\Request;

/**
 * Class Ngw
 *
 * @package d3\heidelpay
 */
class Ngw
{
    /**
     * @return mixed
     */
    public function getCurlError()
    {
        return $this->curlError;
    }
    protected $curlError;

    /**
     * Build up and returns curl ressource
     *
     * @param Request $request
     *
     * @return array
     */
    public function sendXMLRequest(request $request)
    {
        //remove whitespaces, without destroying xml
        $data = preg_replace('@>\s*<@', '><', $request->getData());
        $curl = $this->setupCurl($request, 'load=' . urlencode($data));

        $responseData = $this->excecuteCurl($curl);

        return $responseData;
    }

    /**
     * @param Request $request
     * @param string  $data
     *
     * @return resource
     */
    protected function setupCurl(request $request, $data)
    {
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_TIMEOUT, $request->getCurlTimeOut());
        curl_setopt($curl, CURLOPT_URL, $request->getUrl());
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);

        return $curl;
    }

    /**
     * @param $curl
     *
     * @return mixed
     */
    protected function excecuteCurl($curl)
    {
        $response = curl_exec($curl);

        if (curl_errno($curl) || $response === false) {
            $this->curlError = curl_error($curl);
        }
        curl_close($curl);

        return $response;
    }

    /**
     * @param Request $request
     *
     * @return array
     */
    public function sendPostRequest(Request $request)
    {

        $curl = $this->setupCurl($request, http_build_query($request->getData()));

        $response = $this->excecuteCurl($curl);

        //TODO error handling
        if ($response === false) {
            return array();
        }

        parse_str($response, $responseData);
        foreach($responseData as $key => $value) {
            $responseData[$key] = stripslashes($value);
        }

        return $responseData;
    }

}
