<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 *  @author    D3 Data Development
 *  @copyright 2016 D3 Data Development
 *  @license   LICENSE.txt
 */

ini_set('error_reporting', E_ALL ^ E_NOTICE);


use d3\heidelpay\Ngw;
use d3\heidelpay\response\Parser;
use d3\heidelpay\transactionlog\reader\Transaction;

require_once(dirname(__FILE__) . '/heidelpay.php'); // Base Controller

/**
 * Class HeidelpayResponseModuleFrontController
 */
class HeidelpayResponseModuleFrontController extends HeidelpayModuleFrontController
{
    /**
     *
     */
    const REDIRECT = 'redirect';

    public $currentTransactionId;

    /**
     * @var
     */
    protected $redirectUrl;

    /**
     *
     */
    public function initContent()
    {
        $response = $this->getResponse();

        if (Tools::getIsset('CRITERION_SESSION')) {
            $aTmp                              = explode("__@@", $response['CRITERION_SESSION']);
            $response['heidelpay_input_position'] = $aTmp[0];
            $response['id_customer'] = $aTmp[2];
        }

        $idCart = $this->context->cart->id;
        PrestaShopLogger::addLog(
            __CLASS__ . '::initContent called - response = ' . var_export($response, true),
            1,
            null,
            'Heidelpay Module',
            (int)$idCart,
            true
        );

        if (false == Tools::getIsset('PROCESSING_RESULT')) {
            //TODO: back to step 5
            $this->currentTemplate = 'error.tpl';
            $this->errors          = array("no data was given.");
        } else {
            require_once(_PS_CLASS_DIR_.'/Blowfish.php');
            /** @var BlowFishCore $blowFish */
            $blowFish = new Blowfish(
                HeidelpayModuleFrontController::BLOFISH_KEY,
                HeidelpayModuleFrontController::BLOFISH_VALUE
            );

            $activeRecord                   = new HeidelpayTransactionModel();
            $activeRecord->id_transaction   = $response['IDENTIFICATION_UNIQUEID'];
            $activeRecord->id_customer      = $response['id_customer'];
            $activeRecord->transaction_data = $blowFish->encrypt($this->encode($response));
            if (false == $activeRecord->add()) {
                PrestaShopLogger::addLog(
                    __CLASS__ . ':: coult not save transaction to database',
                    2,
                    null,
                    'Heidelpay Module',
                    (int)$idCart,
                    true
                );
            }
            $this->currentTransactionId = $activeRecord->id;
        }

        $sReturn     = "";
        $transaction = new Transaction();
        $transaction->read($response);
        $parser = new Parser($transaction);

        if (false == $this->isHashValid($response)) {
            $baseUri = $this->context->link->getModuleLink(
                'heidelpay',
                $parser->getActualTransactionData()->getInputposition(),
                array('currenttransactionid' => $this->currentTransactionId)
            );
            PrestaShopLogger::addLog(
                __CLASS__ . '::Hash Is invalid: returnIs:' . $baseUri . '::redirect URL:' . $this->getRedirectUrl(),
                1,
                null,
                'Heidelpay Module',
                (int)$idCart,
                true
            );

            echo $baseUri;
            die;
        }

        $isThreeDSecure = $parser->isThreeDSercure();

        if ($parser->isOnlineTransferPaymentSuccess()) {
            PrestaShopLogger::addLog(
                __CLASS__ . '::isOnlineTransferPaymentSuccess',
                1,
                null,
                'Heidelpay Module',
                (int)$idCart,
                true
            );

            $this->setRedirectUrl(
                $this->context->link->getModuleLink(
                    'heidelpay',
                    'validation',
                    array('currenttransactionid' => $this->currentTransactionId)
                )
            );

            if ('IV.PA' == $transaction->getPaymentcode()) {
                PrestaShopLogger::addLog(
                    __CLASS__ . '::isIVPAResponse',
                    1,
                    null,
                    'Heidelpay Module',
                    (int)$idCart,
                    true
                );
                $sReturn = self::REDIRECT;
            }
        } elseif ($isThreeDSecure) {
            PrestaShopLogger::addLog(
                __CLASS__ . '::processThreeDSecure',
                1,
                null,
                'Heidelpay Module',
                (int)$idCart,
                true
            );
            $sReturn = $this->processThreeDSecure($parser);
        } else {
            PrestaShopLogger::addLog(
                __CLASS__ . '::processResponse',
                1,
                null,
                'Heidelpay Module',
                (int)$idCart,
                true
            );
            $sReturn = $this->processResponse($parser);
        }

        PrestaShopLogger::addLog(
            __CLASS__ . '::returnIs:' . $sReturn . '::redirect URL:' . $this->getRedirectUrl(),
            1,
            null,
            'Heidelpay Module',
            (int)$idCart,
            true
        );

        if ($sReturn === self::REDIRECT) {
            Tools::redirect($this->getRedirectUrl());
        } else {
            echo $this->getRedirectUrl();
            die;
        }
    }

    protected function getResponse()
    {
        return Tools::getAllValues();
    }

    /**
     * process 3d secure data after step 4, returns next action-url
     *
     * @param Parser $parser
     *
     * @return string
     */
    protected function processThreeDSecure(Parser $parser)
    {

        // get payment type
        $query   = array(
            'currenttransactionid' => $this->currentTransactionId
        );

        $baseUri = $this->context->link->getModuleLink(
            'heidelpay',
            $parser->getActualTransactionData()->getInputposition(),
            $query
        );

        if ($parser->isThreeDSecureSuccess()) {
            $baseUri = $this->context->link->getModuleLink(
                'heidelpay',
                'validation',
                $query
            );
        }

        $this->setRedirectUrl($baseUri);

        return $this->getRedirectUrl();
    }

    /**
     * returns sRedirectUrl
     *
     * @return string
     */
    public function getRedirectUrl()
    {
        return $this->redirectUrl;
    }

    /**
     * set property sRedirectUrl and add stoken parameter
     *
     * @param $sReturnURL
     *
     * @return $this
     */
    public function setRedirectUrl($sReturnURL)
    {
        $this->redirectUrl = $sReturnURL;

        return $this;
    }

    /**
     * process input step 4 returns next action/url
     *
     * @param Parser $parser
     *
     * @return string
     */
    protected function processResponse(Parser $parser)
    {

        // get payment type
        $query = array(
            'currenttransactionid' => $this->currentTransactionId
        );

        $controller = $parser->getActualTransactionData()->getInputposition();

        if ($parser->isWaiting()) {
            $query['3dsecure'] = 1;
        } elseif ($parser->isSimpleSuccess()) {
            $controller = 'validation';
        }

        $baseUri = $this->context->link->getModuleLink(
            'heidelpay',
            $controller,
            $query
        );

        $this->setRedirectUrl($baseUri);

        return $this->getRedirectUrl();
    }
}
