<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2016 D3 Data Development
 * @license   LICENSE.txt
 */

use d3\heidelpay\Ngw;
use d3\heidelpay\ngw\Request;
use d3\heidelpay\payment\Directdebit;
use d3\heidelpay\request\Config;
use d3\heidelpay\transactionlog\reader\Transaction;

require_once(dirname(__FILE__) . '/heidelpay.php'); // Base Controller

/**
 * Class HeidelpayDirectdebitModuleFrontController
 */
class HeidelpayDirectdebitModuleFrontController extends HeidelpayModuleFrontController
{
    public $currentTemplate = 'hpc.tpl';
    public $isHeidelpayDebugMode;

    public function initContent()
    {
        $this->isHeidelpayDebugMode = (bool)Configuration::get('HEIDELPAY_LIVE_MODE');
        $this->context->smarty->assign('isHeidelpayDebugMode', $this->isHeidelpayDebugMode);
        $this->context->smarty->assign('isSepaMode', true);

        $currentTransactionId = Tools::getValue('currenttransactionid');
        if (//
            $currentTransactionId //
            && HeidelpayTransactionModel::existsInDatabase($currentTransactionId, "heidelpayTransactions")
        ) {
            /** @var BlowFishCore $blowFish */
            $blowFish = new Blowfish(
                HeidelpayModuleFrontController::BLOFISH_KEY,
                HeidelpayModuleFrontController::BLOFISH_VALUE
            );

            $activeRecord    = new HeidelpayTransactionModel($currentTransactionId);
            $transactionData = $this->decode($blowFish->decrypt($activeRecord->transaction_data));

            $transaction = new Transaction();
            $transaction->read($transactionData);
            if ($transaction->getResult() === 'NOK' || false == $this->isHashValid($transactionData)) {
                $translation = $this->module->l($transaction->getReturncode());
                if ($translation === $transaction->getReturncode()) {
                    $translation = $this->module->l(
                        'An error occurred while processing payment code:' . $translation//
                        . '::' . __LINE__ . '::' . __CLASS__
                    );
                }
                $this->errors = array_merge($this->errors, array($translation));
                $this->context->smarty->assign('error_tpl', $this->module->getTemplatePath("error.tpl"));
            }
        }

        $data = $this->getDataDirectdebit();

        $request = new Request();

        $request->setUrl($this->getHeidelpayUrl());
        $request->setCurlTimeOut($this->getHeidelpayCurlTimeOut());
        $request->setData($data);

        PrestaShopLogger::addLog(
            'HeidelpayResponse::initContent::NGW-request data: ' . var_export($data, true),
            1,
            null,
            'Heidelpay Module',
            (int)$this->context->cart->id,
            true
        );

        $ngw      = new Ngw();
        $response = $ngw->sendPostRequest($request);

        PrestaShopLogger::addLog(
            'HeidelpayResponse::initContent::NGW-response data: ' . var_export($response, true),
            1,
            null,
            'Heidelpay Module',
            (int)$this->context->cart->id,
            true
        );

        if (isset($response['FRONTEND_REDIRECT_URL']) && 'ACK' === $response['PROCESSING_RESULT']) {
            $transaction = new Transaction();
            $transaction->read($response);
            $this->context->smarty->assign('formularUrl', $response['FRONTEND_REDIRECT_URL']);
            $this->context->smarty->assign('brands', $this->getHeidelpayNgwBrands($response));
            $this->addCSS(_MODULE_DIR_ . $this->module->name . '/views/css/front.css');
        } else {
            $this->currentTemplate = 'error.tpl';
            $translation           = $this->module->l($response['PROCESSING_RETURN_CODE']);
            if ($translation === $response['PROCESSING_RETURN_CODE']) {
                //TODO: set default error message
            }
            $this->errors = array_merge($this->errors, array($translation));
            $this->setTemplate("error.tpl");
        }

        parent::initContent();
    }

    protected function getDataDirectdebit()
    {
        $billing_address = new Address($this->context->cart->id_address_invoice);
        $directdebit     = new Directdebit();

        $config = new Config();
        $config->setIsTestmode(!Configuration::get('HEIDELPAY_LIVE_MODE'));

        $config->setResponseUrl(
            $this->context->link->getModuleLink('heidelpay', 'response')
        );

        // TODO: RG moeglich ?
        $paymentCode = $directdebit->getPaymentCode() . "." . Configuration::get('HEIDELPAY_ACCOUNT_TRANSTYPE_DD');

        $data                                  = array();
        $data['REQUEST.VERSION']               = "1.0";
        $data['SECURITY.SENDER']               = Configuration::get('HEIDELPAY_ACCOUNT_SECURITYSENDER');
        $data['FRONTEND.RESPONSE_URL']         = $config->getResponseUrl();
        $data['FRONTEND.MODE']                 = "WHITELABEL";
        $data['FRONTEND.ENABLED']              = "true";
        $data['FRONTEND.LANGUAGE']             = $this->context->language->iso_code;
        $data['FRONTEND.PAYMENT_FRAME_ORIGIN'] = Tools::getShopDomainSsl(true);
        $data['USER.LOGIN']                    = Configuration::get('HEIDELPAY_ACCOUNT_LOGIN');
        $data['USER.PWD']                      = Configuration::get('HEIDELPAY_ACCOUNT_PASSWORD');
        $data['TRANSACTION.MODE']              = $config->getTransactionMode();
        $data['TRANSACTION.CHANNEL']           = Configuration::get('HEIDELPAY_ACCOUNT_CHANNEL_DD');
        $data['PAYMENT.CODE']                  = $paymentCode;
        $data['PRESENTATION.AMOUNT']           = $this->context->cart->getOrderTotal();
        $data['PRESENTATION.CURRENCY']         = $this->context->currency->iso_code;
        $data['TRANSACTION.RESPONSE']          = 'SYNC';
        $data['RISKMANAGEMENT.PROCESS']        = 'AUTO';
        $data['IDENTIFICATION.TRANSACTIONID']  = rand() . "__@@" . date('Ymd-Hms');
        $data['ADDRESS.STREET']                = trim("{$billing_address->address1} {$billing_address->address2}");
        $data['ADDRESS.ZIP']                   = $billing_address->postcode;
        $data['ADDRESS.CITY']                  = $billing_address->city;
        $data['NAME.GIVEN']                    = $this->context->customer->firstname;
        $data['NAME.FAMILY']                   = $this->context->customer->lastname;
        $data['NAME.BIRTHDATE']                = $this->context->customer->birthday;
        $data['ADDRESS.COUNTRY']               = $this->context->country->iso_code;
        $data['NAME.COMPANY']                  = $this->context->customer->company;
        $data['CONTACT.EMAIL']                 = $this->context->customer->email;
        $data['CONTACT.IP']                    = Tools::getRemoteAddr();
        $data['SHOP.TYPE']                     = _PS_VERSION_;
        $data['SHOPMODULE.VERSION']            = $this->module->version;
        $data['CRITERION.SESSION']             = "directdebit__@@" . $this->context->cookie->checksum . '__@@' //
            . $this->context->customer->id;
        $data['CRITERION.HASH']                = $this->generateHash($data);

        return $data;
    }
}
