<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    D3 Data Development
 * @copyright 2016 D3 Data Development
 * @license   LICENSE.txt
 */

use d3\heidelpay\Ngw;
use d3\heidelpay\ngw\Request;
use d3\heidelpay\payment\invoice\Secured;
use d3\heidelpay\request\Config;

require_once(dirname(__FILE__) . '/heidelpay.php'); // Base Controller

/**
 * Class HeidelpayAssuredinvoiceModuleFrontController
 */
class HeidelpayAssuredinvoiceModuleFrontController extends HeidelpayModuleFrontController
{
    public function initContent()
    {
        $data = $this->getDataAssuredinvoice();

        $result = $this->validateCustomerData($data);

        if (false == empty($result)) {
            $this->errors = $result;
            $this->setTemplate("error.tpl");
            parent::initContent();

            return;
        }

        $request = new Request();

        $request->setUrl($this->getHeidelpayUrl());
        $request->setCurlTimeOut($this->getHeidelpayCurlTimeOut());
        $request->setData($data);

        PrestaShopLogger::addLog(
            'HeidelpayResponse::initContent::NGW-request data: ' . var_export($data, true),
            1,
            null,
            'Heidelpay Module',
            (int)$this->context->cart->id,
            true
        );

        $ngw      = new Ngw();
        $response = $ngw->sendPostRequest($request);

        PrestaShopLogger::addLog(
            'HeidelpayResponse::initContent::NGW-response data: ' . var_export($response, true),
            1,
            null,
            'Heidelpay Module',
            (int)$this->context->cart->id,
            true
        );

        if (isset($response['PROCESSING_RESULT']) && 'ACK' === $response['PROCESSING_RESULT']) {
            if (isset($response['CRITERION_SESSION'])) {
                $aTmp                                 = explode("__@@", $response['CRITERION_SESSION']);
                $response['heidelpay_input_position'] = $aTmp[0];
                $response['id_customer']              = $aTmp[2];
            }

            require_once(_PS_CLASS_DIR_ . '/Blowfish.php');
            /** @var BlowFishCore $blowFish */
            $blowFish = new Blowfish(
                HeidelpayModuleFrontController::BLOFISH_KEY,
                HeidelpayModuleFrontController::BLOFISH_VALUE
            );

            $activeRecord                   = new HeidelpayTransactionModel();
            $activeRecord->id_transaction   = $response['IDENTIFICATION_UNIQUEID'];
            $activeRecord->id_customer      = $response['id_customer'];
            $activeRecord->transaction_data = $blowFish->encrypt($this->encode($response));
            if (false == $activeRecord->add()) {
                PrestaShopLogger::addLog(
                    __CLASS__ . ':: coult not save transaction to database',
                    2,
                    null,
                    'Heidelpay Module',
                    (int)$this->context->cart->id,
                    true
                );
            }

            $currentTransactionId = $activeRecord->id;

            Tools::redirect(
                $this->context->link->getModuleLink(
                    'heidelpay',
                    'validation',
                    array('currenttransactionid' => $currentTransactionId)
                )
            );
        }

        $this->currentTemplate = 'error.tpl';
        $translation           = $this->module->l($response['PROCESSING_RETURN_CODE']);
        if ($translation === $response['PROCESSING_RETURN_CODE']) {
            //TODO: set default error message
        }
        $this->errors = array($translation);
        $this->setTemplate("error.tpl");
        parent::initContent();
    }

    protected function getDataAssuredinvoice()
    {
        $assuredinvoice  = new Secured();
        $billing_address = new Address($this->context->cart->id_address_invoice);

        $config = new Config();
        $config->setIsTestmode(!Configuration::get('HEIDELPAY_LIVE_MODE'));

        $config->setResponseUrl(
            $this->context->link->getModuleLink('heidelpay', 'response')
        );

        $paymentCode = $assuredinvoice->getPaymentCode() . ".PA";

        $data                                 = array();
        $data['REQUEST.VERSION']              = "1.0";
        $data['SECURITY.SENDER']              = Configuration::get('HEIDELPAY_ACCOUNT_SECURITYSENDER');
        $data['FRONTEND.RESPONSE_URL']        = $config->getResponseUrl();
        $data['IDENTIFICATION.TRANSACTIONID'] = rand() . "__@@" . date('Ymd-Hms');
        $data['USER.LOGIN']                   = Configuration::get('HEIDELPAY_ACCOUNT_LOGIN');
        $data['USER.PWD']                     = Configuration::get('HEIDELPAY_ACCOUNT_PASSWORD');
        $data['TRANSACTION.MODE']             = $config->getTransactionMode();
        $data['TRANSACTION.RESPONSE']         = 'SYNC';
        $data['TRANSACTION.CHANNEL']          = Configuration::get('HEIDELPAY_ACCOUNT_CHANNEL_ASSUREDINV');
        $data['PAYMENT.CODE']                 = $paymentCode;
        $data['PRESENTATION.AMOUNT']          = $this->context->cart->getOrderTotal();
        $data['PRESENTATION.CURRENCY']        = $this->context->currency->iso_code;
        $data['NAME.GIVEN']                   = $this->context->customer->firstname;
        $data['NAME.FAMILY']                  = $this->context->customer->lastname;
        $data['NAME.COMPANY']                 = $this->context->customer->company;
        $data['NAME.BIRTHDATE']               = $this->context->customer->birthday;
        $data['CONTACT.EMAIL']                = $this->context->customer->email;
        $data['CONTACT.IP']                   = Tools::getRemoteAddr();
        $data['ADDRESS.COUNTRY']              = $this->context->country->iso_code;
        $data['ADDRESS.STREET']               = trim("{$billing_address->address1} {$billing_address->address2}");
        $data['ADDRESS.ZIP']                  = $billing_address->postcode;
        $data['ADDRESS.CITY']                 = $billing_address->city;
        $data['SHOP.TYPE']                    = "PrestaShop " . _PS_VERSION_;
        $data['SHOPMODULE.VERSION']           = $this->module->version;
        $data['CRITERION.SESSION']            = "assuredinvoice__@@" . $this->context->cookie->checksum . '__@@' //
            . $this->context->customer->id;
        $data['CRITERION.HASH']               = $this->generateHash($data);

        return $data;
    }
}
